#pragma once


class Sample;
class ArgList;
class CEgFileSpec;
class PixPort;

#if EG_MAC
#include <Quickdraw.h>
#endif

#include "XPtrList.h"
#include "WC_WaveShape.h"
#include "Camera.h"
#include "ExpressionDict.h"

struct ScrnPt {
	long x, y;
	RGBColor color;
};



class WhiteCapWorld {

	public:
						WhiteCapWorld();
						~WhiteCapWorld();
		
		void 			Init( const CEgFileSpec* inConfig, long inTransitionTime );
				
		void			RecordSample( long inCurTime, const float inSpectrum[] );

		void			Render( long inCurTime, PixPort& inDest, Rect& outDirtyRect );
		
		void			SetPaneRect( const Rect& inRect );
		
		void			RefreshRect( const Rect& inRect );

		const Rect*		PaneRect() const			{ return &mPaneRect;	}
	
		void			ExpireSamples();
		
		// Draws the config title string to inPort and updates mTitleRect
		void			DrawConfigName( void* inPort );	
		
		Rect			mTitleRect;			// Where the title currently resides

	protected:
		WC_WaveShape	mWave1, mWave2;
		WC_WaveShape*	mNextWave, *mWave;
		
		float			mNextShapeChange;
		long			mTransitionEnd;
		long			mTransitionTime;
		#define			TRANSITION_ALPHA	1.7
		
		
		Camera			mCamera;
		
		// The current background color
		long			mCurBackClr;
		RGBColor		mCurBackClrRGB;
		RGBColor		mTextColor;


		Rect			mRenderedRect;		// The part in pane that's not background
	
		Rect			mPaneRect;


		float*			mMagPtr;
		float			mT, mDT, mST, mS, mBass1, mBass2, mBass3, mTransitionT, mPi, mNumSampleBins;
		ExpressionDict	mDict;
				
			
		
		// Stuff dealing with keeping track of the sample data
		long					mLastSampleTime;
		Sample*					mSamples;
		Sample*					mRecentSample;
		XPtrList				mFreeList;
		void					discardExpiredRows( long inCurTime );



};

